
(* 4x3 flyways 2 xbot sample cam set as cam 128 (position interval = 1 mm) - cam motion *)
FUNCTION_BLOCK Example17_cam
	(*move async move to 60,60 and 60,180*)
	xbotID_array78[0] := 1;xbotID_array78[1] := 2;
	PosX_array78[0] := 0.06;PosX_array78[1] := 0.06;
	PosY_array78[0] := 0.06;PosY_array78[1] := 0.18;
	PMC_AutoDrivingMotion1(PM_Controller := PM_Controller,Execute := Execute,nXbots := 2,RoutingType := 0,ZoneID := 0,XbotID := xbotID_array78,PosX := PosX_array78,PosY := PosY_array78);

	(*setup cam with xbot 2 y as slave to xbot 1 x*)
	slave_axis_array7[0] := 2;
	cam_ID_array7[0] := 128;
	master_xbot_ID_array7[0] := 1;
	master_axis_array7[0] := 1;
	PMC_CamModeCtrl1(PM_Controller := PM_Controller,Execute := PMC_AutoDrivingMotion1.Done,cmdLB := 2,Level := 1,SlaveXID := 2,nAxis := 1,SlaveAID := slave_axis_array7,camID := cam_ID_array7,MasterXID := master_xbot_ID_array7,MasterAID := master_axis_array7);

	(*move xbot 1 to (400,60)*)
	PMC_XYMotion1(PM_Controller := PM_Controller,Execute := PMC_CamModeCtrl1.Done,cmdLB := 3,XbotID := 1,Mode := 0,Type_ := 0,PosX := 0.4,PosY := 0.06,EndVel := 0,MaxVel := 0.25,MaxAcc := 10);

	(*move xbot 1 to (60,60)*)
	PMC_XYMotion2(PM_Controller := PM_Controller,Execute := PMC_XYMotion1.Done,cmdLB := 4,XbotID := 1,Mode := 0,Type_ := 0,PosX := 0.06,PosY := 0.06,EndVel := 0,MaxVel := 0.25,MaxAcc := 10);

	(*disable cam on xbot 2 *)
	PMC_CamModeCtrl2(PM_Controller := PM_Controller,Execute := PMC_XYMotion2.Done,cmdLB := 5,Level := 0,SlaveXID := 2,nAxis := 1,SlaveAID := slave_axis_array7,camID := cam_ID_array7,MasterXID := master_xbot_ID_array7,MasterAID := master_axis_array7);

	(*move to new start position (60,60) and (480,420)*)
	xbotID_array78[0] := 1;xbotID_array78[1] := 2;
	PosX_array78[0] := 0.06;PosX_array78[1] := 0.48;
	PosY_array78[0] := 0.06;PosY_array78[1] := 0.42;
	PMC_AutoDrivingMotion2(PM_Controller := PM_Controller,Execute := PMC_CamModeCtrl2.Done,nXbots := 2,RoutingType := 0,ZoneID := 0,XbotID := xbotID_array78,PosX := PosX_array78,PosY := PosY_array78);

	(*setup advanced cam*)
	SlaveAID_array4[0] := 1; SlaveAID_array4[1] := 2;
	camID_array4[0] := 128; camID_array4[1] := 128;
	MasterXID_array4[0] := 1; MasterXID_array4[1] := 1;
	MasterAID_array4[0] := 1;MasterAID_array4[1] := 1;
	MasterAOffset_array4[0] := 0; MasterAOffset_array4[1] := 0;
	SlaveAOffset_array4[0] := 0; SlaveAOffset_array4[1] := 0;
	MasterAScaling_array4[0] := 1; MasterAScaling_array4[1] := 2;
	SlaveAScaling_array4[0] := 2; SlaveAScaling_array4[1] := 1;
	CamMode_array4[0] := 1; CamMode_array4[1] := 1;
	MasterOffsetMode_array4[0] := 1; MasterOffsetMode_array4[1] := 1;
	PMC_CamModeCtrlAdvanced1(PM_Controller := PM_Controller,Execute := PMC_AutoDrivingMotion2.Done,cmdLB := 6,Level := 1,SlaveXID := 2,nAxis := 2,SlaveAID := SlaveAID_array4,camID := camID_array4,MasterXID := MasterXID_array4,MasterAID := MasterAID_array4,MasterAOffset := MasterAOffset_array4,SlaveAOffset := SlaveAOffset_array4,MasterAScaling := MasterAScaling_array4,SlaveAScaling := SlaveAScaling_array4,CamMode := CamMode_array4,MasterOffsetMode := MasterOffsetMode_array4);
						
	(*move xbot 1 to (400,60)*)
	PMC_XYMotion3(PM_Controller := PM_Controller,Execute := PMC_CamModeCtrlAdvanced1.Done,cmdLB := 7,XbotID := 1,Mode := 0,Type_ := 0,PosX := 0.9,PosY := 0.06,EndVel := 0,MaxVel := 0.25,MaxAcc := 10);

	(*move xbot 1 to (60,60)*)
	PMC_XYMotion4(PM_Controller := PM_Controller,Execute := PMC_XYMotion3.Done,cmdLB := 8,XbotID := 1,Mode := 0,Type_ := 0,PosX := 0.06,PosY := 0.06,EndVel := 0,MaxVel := 0.25,MaxAcc := 10);

	(*disable advanced cam*)
	PMC_CamModeCtrlAdvanced2(PM_Controller := PM_Controller,Execute := PMC_XYMotion4.Done,cmdLB := 9,Level := 0,SlaveXID := 2,nAxis := 2,SlaveAID := SlaveAID_array4,camID := camID_array4,MasterXID := MasterXID_array4,MasterAID := MasterAID_array4,MasterAOffset := MasterAOffset_array4,SlaveAOffset := SlaveAOffset_array4,MasterAScaling := MasterAScaling_array4,SlaveAScaling := SlaveAScaling_array4,CamMode := CamMode_array4,MasterOffsetMode := MasterOffsetMode_array4);
						
	Done := PMC_CamModeCtrlAdvanced2.Done;
END_FUNCTION_BLOCK
